% *************************************************************************
% 
%                      iGem Modelling - 2018
%                     Delft University of Technology
% 
% *************************************************************************
% 
%               Title
% 
%                    File: Additonal Figure for Wiki Page
% 
%              
% *************************************************************************
clear all
close all

%Time Span
Time1 = linspace(17, 18, 10);
Time2 = linspace(18, 20, 10);

%Create range of EPO steady states
EPO_t = [9.8 19.6];

% CFU-E Apoptosis Rate variables
a1 = 0.35; b1 = 0.07;
c1 = 3; k1 = 0.14;

%Calculate CFU-E Apoptosis Rate
alpha_q = (a1-b1)./(1+exp(k1*EPO_t-c1)) + b1;

%Bone Marrow Reticulocyte Maturation Velocity variables
a2 = 2; b2 = 0.35;
c2 = 2.3; k2 = 0.2;

%Calculate Reticulocyte Maturation Velocity
vs = (a2-b2)./(1+exp(-k2*EPO_t+c2)) + b2;
% vs2 = (b2 - a2 )./(1+exp(-k2*Et+c2)) + a2;
% vs2 = 1.5./vs;
Transit_Time =  3 - (3-0.75)*(vs-0.5)/(2-0.5); 

%Initial BFU-E population at maturity of 0 days
S0 = 10^8;

% Proliferation Rates
Bp = 0.2; %/day
Bq = 0.57; %/day
Br = 1.024; %day

% Apoptosis Rates
alpha_s = 0.089; %/day
alpha_m = 0.005; %/day

%Neocytolysis Parameters
tau_E = 9.8;
c_E = 3.5;
k_E = 3;
b_E = 0.1;

%Start and End points
BFU_E_start = 0; %BFU-E start
CFU_E_start = 7; %CFU-E start
Erythroblasts_start = 13; %Erythroblasts start
Reticulocyte_start = 18; %Reticulocyte start
Erythrocytes_start1 = 21; %Erythrocytes start1
Erythrocytes_start2 = 35; %Erythrocytes start2
Erythrocytes_start3 = 42; %Erythrocytes start3
Erythrocytes_end = 141; %Erythrocytes end3


%Calculate BFU-E cells Entering CFU-E stage
BFU_E_end = S0*exp(Bp*CFU_E_start);

%Caluculate BFU-E count
BFU_E_fun =  @(mu) S0*exp(Bp .* mu);
BFU_E_count = integral(BFU_E_fun,0,CFU_E_start);

%Initiallize SS Red Blood Cell range vector
mesh = 1000;

%Intialize SS Red Blood Cell count
Progenitor_count = [];
Erythroblasts_count = [];
RBC_count_total = [];
CFU_E_end_hold = [];

for ii = 1:length(EPO_t)
    
    CFU_E_end = BFU_E_end*exp((Bq - alpha_q(ii))*(Erythroblasts_start - CFU_E_start));
    CFU_E_end_hold = [CFU_E_end_hold CFU_E_end];
    CFU_E_fun = @(mu) BFU_E_end*exp((Bq - alpha_q(ii)).* mu);
    CFU_E_count = integral(CFU_E_fun,0,Erythroblasts_start - CFU_E_start);
    Progenitor_count = [Progenitor_count (BFU_E_count + CFU_E_count)];
    
    Erythroblasts_end = CFU_E_end*exp(Br*(Reticulocyte_start - Erythroblasts_start));
    Erythroblasts_fun = @(mu) CFU_E_end*exp(Br .* mu);
    Erythroblasts_total = integral(Erythroblasts_fun, 0, Reticulocyte_start - Erythroblasts_start);
    Erythroblasts_count = [Erythroblasts_count Erythroblasts_total];
    
    Reticulocyte_end = Erythroblasts_end*exp(-alpha_s*(Transit_Time(ii)));
    
    RBC_fun1 = @(mu) Reticulocyte_end*exp(-alpha_m .* mu);
    RBC_end1 = RBC_fun1(Erythrocytes_start2-(Transit_Time(ii)+Reticulocyte_start));
    RBC_count1 = integral(RBC_fun1,0,Erythrocytes_start2-(Transit_Time(ii)+Reticulocyte_start));
    
    if EPO_t(ii) < tau_E
            alpha_m_n = alpha_m + min(c_E/EPO_t(ii)^k_E , b_E);
        else
            alpha_m_n = alpha_m;
    end
    
    RBC_fun2 = @(mu) RBC_end1*exp(-alpha_m_n .* mu);
    RBC_end2 = RBC_fun2(Erythrocytes_start3-Erythrocytes_start2);
    RBC_count2 = integral(RBC_fun2,0,Erythrocytes_start3-Erythrocytes_start2);
    
    RBC_fun3 = @(mu) RBC_end2*exp(-alpha_m .* mu);
    RBC_end3 = RBC_fun3(Erythrocytes_end- Erythrocytes_start3);
    RBC_count3 = integral(RBC_fun3,0,Erythrocytes_end- Erythrocytes_start3);
    
    RBC_count = RBC_count1 + RBC_count2 + RBC_count3;
    
    RBC_count_total = [RBC_count_total RBC_count];
end

Ery1 = CFU_E_end_hold(1)*exp(Br*(Time1-13))
Ery2 = CFU_E_end_hold(2)*exp(Br*(Time1-13))
Reti1 = Ery1(end)*exp(-alpha_s*(Time2-18))
Reti2 = Ery2(end)*exp(-alpha_s*(Time2-18))

figure(1)
plot(Time1, Ery1, '*b', 'LineWidth',2); hold on;
% plot(Time1, Ery2, 'b', 'LineWidth',2)
plot(Time2, Reti1, '*r', 'LineWidth',2)
% plot(Time2, Reti2, 'r', 'LineWidth',2)
plot([18 18], [1e11 3.5e11], '--k', 'LineWidth',2)
set(gca,'fontsize',16)
set(gcf,'color','w'); 
xlabel('Cell Maturity (days)') 
ylabel('Cell Population')
legend('Erythroblasts Stage', 'Reticulocyte Stage', 'Stage Boundary')

% plot(EPO_t, RBC_count_total/1e12, 'r', 'LineWidth',2); hold on;
% plot([9.8 9.8], [0 120],'--b' )
% plot([3.271066310 3.271066310], [0 120], 'k--')
% plot([0 75], [40 40], '--r', 'LineWidth',2)
% xlabel('EPO Concentration (mU/mL)', 'FontSize', 14) 
% ylabel('Red Blood Cell Population (# of cells x10^{12})', 'FontSize', 14)
% legend('Steady State Red blood cell count', 'Neocytolysis Trigger (EPO < 9.8 mU/ml)', ...
%     'Maximum Neocytolysis Rate Reached', 'Stroke Risk (RBC Population > 40x10^{12})')
% xlim([0 75])
% figure(2)
% plot(EPO_t, RBC_count_total/1e12, 'LineWidth',2)
% xlim([3.3 23.4])

Steady_State_RBC = interp1(EPO_t,RBC_count_total/1e12,9.8)
Steady_State_strokeEPO = interp1(RBC_count_total/1e12,EPO_t, 40)